/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.lifecycle;

import icyllis.modernui.ModernUI;
import icyllis.modernui.lifecycle.ViewModel;
import icyllis.modernui.lifecycle.ViewModelStore;
import icyllis.modernui.lifecycle.ViewModelStoreOwner;
import javax.annotation.Nonnull;

public class ViewModelProvider {
    private final IFactory factory;
    private final ViewModelStore viewModelStore;

    public ViewModelProvider(@Nonnull ViewModelStoreOwner owner) {
        this(owner.getViewModelStore(), (IFactory)NewInstanceFactory.getInstance());
    }

    public ViewModelProvider(@Nonnull ViewModelStoreOwner owner, @Nonnull IFactory factory) {
        this(owner.getViewModelStore(), factory);
    }

    public ViewModelProvider(@Nonnull ViewModelStore store, @Nonnull IFactory factory) {
        this.factory = factory;
        this.viewModelStore = store;
    }

    @Nonnull
    public <T extends ViewModel> T get(@Nonnull Class<T> modelClass) {
        String canonicalName = modelClass.getCanonicalName();
        if (canonicalName == null) {
            throw new IllegalArgumentException("Local and anonymous classes can not be ViewModels");
        }
        return this.get(canonicalName, modelClass);
    }

    @Nonnull
    public <T extends ViewModel> T get(@Nonnull String key, @Nonnull Class<T> modelClass) {
        ViewModel viewModel = this.viewModelStore.get(key);
        if (modelClass.isInstance(viewModel)) {
            return (T)viewModel;
        }
        if (viewModel != null) {
            ModernUI.LOGGER.warn(ViewModel.MARKER, "ViewModel {} got by key {} does not match model class {}, a new instance is overriding the previous one", (Object)viewModel, (Object)key, modelClass);
        }
        viewModel = this.factory.create(key, modelClass);
        this.viewModelStore.put(key, viewModel);
        return (T)viewModel;
    }

    public static class NewInstanceFactory
    implements IFactory {
        private static NewInstanceFactory sInstance;

        @Nonnull
        static NewInstanceFactory getInstance() {
            if (sInstance == null) {
                sInstance = new NewInstanceFactory();
            }
            return sInstance;
        }

        @Override
        @Nonnull
        public <T extends ViewModel> T create(@Nonnull String key, @Nonnull Class<T> modelClass) {
            try {
                return (T)((ViewModel)modelClass.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface IFactory {
        @Nonnull
        public <T extends ViewModel> T create(@Nonnull String var1, @Nonnull Class<T> var2);
    }
}

